int laser1stat = 0;
void _ISR _T2Interrupt(void) {
	_T2IF=0;
	
	laser1stat = !laser1stat;

	if (laser1stat ) {
		L2 = 1;			//L2 will output frequencies at 50% duty cycle
		L3 = 1;			//L3 will give 5-ms pulse @ same frequencies
		PR3 = 50000; 	// set up 5-ms pulse
		T3CONbits.TCKPS = 0;
		
		T3CONbits.TON = 1; 
		_T3IE = 1;
	} else {
		L2 = 0;
	}	
}



void _ISR _T3Interrupt(void) {
	_T3IF=0;
	L3=0;
}

void _ISR _T4Interrupt(void) {
	_T4IF=0;
}

void _ISR _T5Interrupt(void) {
	_T5IF=0;
	L4=!L4;
}

void initTimers(void) {
	
	////////////////////////////////
	// 
	//   Timer setup
	//
	//
	

	T1CONbits.TON = 0;         //turn on timer 1
	T1CONbits.TCKPS = 0b00;		//prescaler 1:1 (also avail: 8, 64, 256)
	T1CONbits.TCS = 0;			//clock mode: internal (Fcy)
	T1CONbits.TGATE = 0; 		//don't know what this is but leave 0; breaks when on
	T1CONbits.TSYNC = 0;		//ignored when TCS = 0
	PR1 =10000;					//10000 when TCKPS=0b00 gives 1kHz interupt
								//39064 with TCKPS=0b11 gives 1Hz interrupt
								//(19532 when TCKPS =0b11 gives 2Hz interrupt--old version when i used mastertick*2 in main.c, rather than mastertick)
	_T1IE = 0;				//enable T1 interrupt
	_T1IP = 0b1111;				//priority 7 (highest priority)


	T2CONbits.TON = 0;          //turn on timer 2
	T2CONbits.TCKPS = 0b11;		//prescaler
	T2CONbits.TCS = 0;			//clock mode: internal (Fcy)
	T2CONbits.TGATE = 0;
	T2CONbits.T32 = 0;			//32-bit-timer enable bit - leave as two 16-bit timers
	PR2 = 19532;
	_T2IE = 0;					//enable T2 interrupt
	_T2IP = 0b1111;				//priority 7 (highest priority)



	T3CONbits.TON = 0;          //turn on timer 3
	T3CONbits.TCKPS = 0b00;		//prescaler
	T3CONbits.TCS = 0;			//clock mode: internal (Fcy)
	T3CONbits.TGATE = 0;
	PR3 = 10000;			//16-bit timer1-period register
	_T3IE = 0;					//enable T3 interrupt
	_T3IP = 0b1111;				//priority 7 (highest priority)


//being used by stim() to set pulse lengths
	T4CONbits.TON = 0;          //turn on timer 4
	T4CONbits.TCKPS = 0b11;		//prescaler
	T4CONbits.TCS = 0;			//clock mode: internal (Fcy)
	T4CONbits.TGATE = 0;
	T4CONbits.T32 = 0;			//32-bit-timer enable bit
	PR4 = 39062;			//16-bit timer1-period register
	_T4IE = 0;					//enable T4 interrupt
	_T4IP = 0b1;				//priority 7 (highest priority)


	T5CONbits.TON = 1;          //turn on timer 5
	T5CONbits.TCKPS = 0b00;		//prescaler
	T5CONbits.TCS = 0;			//clock mode: internal (Fcy)
	T5CONbits.TGATE = 0;
	PR5 = 50000;				//16-bit timer1-period register
	_T5IE = 1;					//enable T5 interrupt
	_T5IP = 0b1;				//priority 7 (highest priority)


}









